<?php
/**
 * ChainEX Engine Init Library
 *
 * Functions for initialising engine
 *
 * @category   Chainex-API
 * @package    Engine
 * @copyright  Copyright (c) 2018 ChainEX
 * @version    1.0.0
 */

$className = 'engineInit';

class engineInit
{
    //public $auth;
    public $database;
    //public $general;
    public $library;
    public $loaded;

    public function __construct()
    {
        include_once(__DIR__.'/../database/database.mysql.php');
        $this->database = new databaseMysql();
    }

    /**
     * Load libraries
     *
     * @param  string  $libraryName  String of library to load
     */
    public function loadLibrary($libraryName)
    {

        if (!isset($this->loaded[$libraryName])) {

            // Explode the lib to load
            $exploded = explode("/", $libraryName);

            // Check to see if we are loading a specific library file or starting the application
            if (!empty($exploded[1])) {

                // Load a specific file
                $toLoad = __DIR__."includes/libs/" . $exploded[0] . "/" . $exploded[0] . "." . $exploded[1] . ".php";

                // Check it exists
                if (file_exists($toLoad)) {

                    // Load it
                    require_once $toLoad;

                    // Start the class
                    $this->library[$className] = new $className($this);
                    $this->loaded[$libraryName] = 1;

                }

            }

        }

    }

}
