<?php
class tbl_page
{

    public $database;

    public $items;

    /**
     * Required to access the other library functions
     * @param  class  &$database
     */
    public function __construct(&$database)
    {
        $this->database = $database;
        $items = array();
    }

    public function new()
    {
        return new tbl_page_item();
    }

    public function fetch($id)
    {
        $query = "SELECT `tbl_page`.`id`, `tbl_page`.`page`, `tbl_page`.`layout`, `tbl_page`.`order`, `tbl_page`.`footer`, `tbl_page`.`active`, `tbl_page`.`datecreated`
                    FROM `tbl_page` 
                    WHERE `tbl_page`.`id` = '$id';";
        $data = $this->database->query(0, $query);
        $result = !empty($data) ? $this->format($data[0]) : new tbl_page_item();
        return $result;
    }

    public function all($active = null)
    {
        $result = array();
        $query = "SELECT `tbl_page`.`id`, `tbl_page`.`page`, `tbl_page`.`layout`, `tbl_page`.`order`, `tbl_page`.`footer`, `tbl_page`.`active`, `tbl_page`.`datecreated`
                    FROM `tbl_page`
                    " . ($active != null ? "WHERE `tbl_page`.`active` = '$active'" : "") . "
                    ORDER BY `tbl_page`.`order`;";
        $data = $this->database->query(0, $query);
        foreach ($data as $item) {
            $result[] = $this->items[] = $this->format($item);
        }
        return $result;
    }

    private function format($data)
    {
        $item = $this->new();
        foreach ($data as $col => $val) {
            eval('$item->' . $col . ' = $val;');
        }
        return $item;
    }

    public function add($item)
    {
        $this->items[] = $item;
    }

    public function save()
    {
        if (!empty($this->items)) {
            foreach ($this->items as $item) {
                $inputs = array(
                    ":page" => $item->page,
                    ":layout" => $item->layout,
                    ":order" => $item->order,
                    ":footer" => $item->footer,
                    ":active" => $item->active
                );
                if ($item->id === null) {
                    $query = "INSERT INTO `tbl_page`
                    (`page`,
                        `layout`,
                        `order`,
                        `footer`,
                        `active`,
                        `datecreated`)
                    VALUES
                    (:page,
                        :layout,
                        :order,
                        :footer,
                        :active,
                        NOW());";
                    $item->id = $this->database->query(1, $query, $inputs);
                } else {
                    $inputs[":id"] = $item->id;
                    $query = "UPDATE `tbl_page`
                    SET `page` = :page,
                        `layout` = :layout,
                        `order` = :order,
                        `footer` = :footer,
                        `active` = :active
                    WHERE `id` = :id";
                    $this->database->query(1, $query, $inputs);
                }
            }
        }
    }
}

class tbl_page_item
{
    public $id;
    public $page;
    public $layout;
    public $order;
    public $footer;
    public $active;
    public $datecreated;
}
