<?php
class tbl_contact_message
{

    public $database;

    public $items;

    /**
     * Required to access the other library functions
     * @param  class  &$database
     */
    public function __construct(&$database)
    {
        $this->database = $database;
        $items = array();
    }

    public function new()
    {
        return new tbl_contact_message_item();
    }

    public function fetch($id)
    {
        $query = "SELECT `tbl_contact_message`.`id`, `tbl_contact_message`.`name`, `tbl_contact_message`.`email`, `tbl_contact_message`.`subject`, `tbl_contact_message`.`message`, `tbl_contact_message`.`mail_to`, `tbl_contact_message`.`mail_subject`, `tbl_contact_message`.`mail_message`, `tbl_contact_message`.`datecreated`
                    FROM `tbl_contact_message` 
                    WHERE `tbl_contact_message`.`id` = '$id';";
        $data = $this->database->query(0, $query);
        $result = !empty($data) ? $this->format($data[0]) : new tbl_contact_message_item();
        return $result;
    }

    public function all()
    {
        $result = array();
        $query = "SELECT `tbl_contact_message`.`id`, `tbl_contact_message`.`name`, `tbl_contact_message`.`email`, `tbl_contact_message`.`subject`, `tbl_contact_message`.`message`, `tbl_contact_message`.`mail_to`, `tbl_contact_message`.`mail_to`, `tbl_contact_message`.`mail_subject`, `tbl_contact_message`.`mail_message`, `tbl_contact_message`.`datecreated`
                    FROM `tbl_contact_message`;";
        $data = $this->database->query(0, $query);
        foreach ($data as $item) {
            $result[] = $this->items[] = $this->format($item);
        }
        return $result;
    }

    private function format($data)
    {
        $item = $this->new();
        foreach ($data as $col => $val) {
            eval('$item->' . $col . ' = $val;');
        }
        return $item;
    }

    public function add($item)
    {
        $this->items[] = $item;
    }

    public function save()
    {
        if (!empty($this->items)) {
            foreach ($this->items as $item) {
                $inputs = array(
                    ":name" => $item->name,
                    ":email" => $item->email,
                    ":subject" => $item->subject,
                    ":message" => $item->message,
                    ":mail_to" => $item->mail_to,
                    ":mail_subject" => $item->mail_subject,
                    ":mail_message" => $item->mail_message
                );
                if ($item->id === null) {
                    $query = "INSERT INTO `tbl_contact_message`
                    (`name`,
                        `email`,
                        `subject`,
                        `message`,
                        `mail_to`,
                        `mail_subject`,
                        `mail_message`,
                        `datecreated`)
                    VALUES
                    (:name,
                        :email,
                        :subject,
                        :message,
                        :mail_to,
                        :mail_subject,
                        :mail_message,
                        NOW());";
                    $item->id = $this->database->query(1, $query, $inputs);
                } else {
                    $inputs[":id"] = $item->id;
                    $query = "UPDATE `tbl_contact_message`
                    SET `name` = :name,
                        `email` = :email,
                        `subject` = :subject,
                        `message` = :message,
                        `mail_to` = :mail_to,
                        `mail_subject` = :mail_subject,
                        `mail_message` = :mail_message
                    WHERE `id` = :id";
                    $this->database->query(1, $query, $inputs);
                }
            }
        }
    }
}

class tbl_contact_message_item
{
    public $id;
    public $name;
    public $email;
    public $subject;
    public $message;
    public $mail_to;
    public $mail_subject;
    public $mail_message;
    public $datecreated;
}
