<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\MessagesController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PageItemController;
use App\Http\Controllers\SiteSettingsController;
use App\Http\Middleware\UnderConstruction;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware([UnderConstruction::class])->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/#contact', [HomeController::class, 'index'])->name('contact');
    Route::post("/contact", [MessagesController::class, "store"])->name("contact.store");
});

Route::prefix('admin')->group(function () {
    Route::name('admin.')->group(function () {
        Route::middleware('auth')->group(function () {
            Route::get("/",  [HomeController::class, "settings"])->name("home");
            Route::get("/messages/settings", [MessagesController::class, "settings"])->name("messages.settings");
            Route::get("/{page}/settings", [PageController::class, "settings"])->name("page.settings");
            Route::put("/",  [SiteSettingsController::class, "update"])->name("home.update");
            Route::get("/messages", [MessagesController::class, "index"])->name("messages");
            Route::get("/messages/{message}", [MessagesController::class, "show"])->name("messages.show");
            Route::get("/{page}", [PageController::class, "index"])->name("page");
            Route::get("/{page}/create", [PageItemController::class, "create"])->name("page.page_item.create");
            Route::post("/{page_item}", [PageItemController::class, "store"])->name("page.page_item.store");
            Route::get("/{page}/{page_item}/edit", [PageItemController::class, "edit"])->name("page.page_item.edit");
            Route::put("/{page}/{page_item}", [PageItemController::class, "update"])->name("page.page_item.update");
            Route::delete("/{page}/{page_item}", [PageItemController::class, "destroy"])->name("page.page_item.destroy");
        });
    });
});

Auth::routes();

Route::get('/underconstruction', function () {
    return view('public.under_construction');
})->name('underconstruction');
