<x-public-layout>
    <x-slot name="title">
        Nash Vandayar &amp; Associates
    </x-slot>
    <!-- About-->
    <section class="page-section" id="about">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @if ($about)
                        @if ($about->image)
                            <img src="{{ $about->image }}" class="m-2 ms-5"
                                style="width: 480px; float: right; border: 2px solid dimgray" alt=""
                                draggable="false">
                        @endif
                        @if ($about->title)
                            <h2 class="section-heading text-uppercase">
                                {!! $about->title !!}
                            </h2>
                        @endif
                        @if ($about->content)
                            {!! $about->content !!}
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </section>
    @if ($services)
        <!-- Services Grid-->
        <section class="page-section bg-light" id="services">
            <div class="container">
                <div class="text-center">
                    <h2 class="section-heading mb-4 text-uppercase">Services</h2>
                    @if (array_key_exists('page-services-sub-heading', $site_settings) && $site_settings['page-services-sub-heading'])
                        <h3 class="section-subheading text-muted">{!! $site_settings['page-services-sub-heading']['value'] !!}</h3>
                    @endif
                </div>
                <div class="row">
                    @foreach ($services as $service)
                        <div class="col-lg-3 col-sm-6 mb-4 d-flex align-items-stretch">
                            <!-- Service item 1-->
                            <div class="service-item">
                                <a class="service-link" data-bs-toggle="modal" href="#serviceModal_{{ $service->id }}">
                                    <div class="service-hover">
                                        <div class="service-hover-content"><i class="fas fa-plus fa-3x"></i></div>
                                    </div>
                                    <img class="img-fluid" src="{{ $service->thumb_image }}" alt="..." />
                                </a>
                                <div class="service-caption">
                                    <div class="service-caption-subheading text-muted">{!! $service->title !!}</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    @if ($team)
        <!-- Team-->
        <section class="page-section" style="background-color: antiquewhite;" id="team">
            <div class="container">
                <div class="text-center">
                    <h2 class="section-heading text-uppercase">Our Amazing Team</h2>
                    @if (array_key_exists('page-team-sub-heading', $site_settings) && $site_settings['page-team-sub-heading'])
                        <h3 class="section-subheading text-muted">{!! $site_settings['page-team-sub-heading']['value'] !!}</h3>
                    @endif
                </div>
                <div class="row">
                    @foreach ($team as $team_member)
                        <div class="col-lg-4">
                            <div class="team-member">
                                <img class="mx-auto rounded-circle"
                                    src="{{ $team_member->image ? $team_member->image : '/assets/img/page_layouts/team/avatar.jpg' }}"
                                    alt="..." />
                                <h4>{{ $team_member->title }}</h4>
                                <p>{!! $team_member->intro !!}</p>
                                <p class="text-muted">
                                    {!! $team_member->content !!}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if (array_key_exists('page-team-footer-text', $site_settings) && $site_settings['page-team-footer-text'])
                    <div class="row">
                        <div class="col-lg-8 mx-auto text-center">
                            <p class="large text-muted">{!! $site_settings['page-team-footer-text']['value'] !!}</p>
                        </div>
                    </div>
                @endif
            </div>
        </section>
    @endif
    <!-- Contact-->
    <section class="page-section" id="contact">
        <div class="container">
            <div class="text-center">
                <h2 class="section-heading text-uppercase">Contact Us</h2>
                <h3 class="section-subheading">Lorem ipsum dolor sit amet consectetur.</h3>
            </div>
            <form id="contactForm" action="{{ route('contact.store') }}" method="POST">
                @csrf
                <div class="row align-items-stretch mb-5">
                    <div class="col-md-4">
                        @if (array_key_exists('page-contact-location', $site_settings) && $site_settings['page-contact-location'])
                            <h3>Location:</h3>
                            <p>{!! $site_settings['page-contact-location']['value'] !!}</p>
                        @endif

                        @if (array_key_exists('page-contact-email', $site_settings) && $site_settings['page-contact-email'])
                            <h3>Email:</h3>
                            <p>{!! $site_settings['page-contact-email']['value'] !!}</p>
                        @endif

                        @if (array_key_exists('page-contact-tel', $site_settings) && $site_settings['page-contact-tel'])
                            <h3>Call:</h3>
                            <p>{!! $site_settings['page-contact-tel']['value'] !!}</p>
                        @endif
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <!-- Name input-->
                            <input class="form-control" id="name" name="name" type="text" placeholder="Your Name *" required
                                data-sb-validations="required" />
                            <div class="invalid-feedback" data-sb-feedback="name:required">A name is required.</div>
                        </div>
                        <div class="form-group">
                            <!-- Email address input-->
                            <input class="form-control" id="email" name="email" type="email" placeholder="Your Email *" required
                                data-sb-validations="required,email" />
                            <div class="invalid-feedback" data-sb-feedback="email:required">An email is required.
                            </div>
                            <div class="invalid-feedback" data-sb-feedback="email:email">Email is not valid.</div>
                        </div>
                        <div class="form-group mb-md-0">
                            <!-- Phone number input-->
                            <input class="form-control" id="phone" name="phone" type="tel" placeholder="Your Phone *" required
                                data-sb-validations="required" />
                            <div class="invalid-feedback" data-sb-feedback="phone:required">A phone number is
                                required.</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group form-group-textarea mb-md-0">
                            <!-- Message input-->
                            <textarea class="form-control" id="message" name="message" placeholder="Your Message *" required data-sb-validations="required"></textarea>
                            <div class="invalid-feedback" data-sb-feedback="message:required">A message is required.
                            </div>
                        </div>
                    </div>
                </div>
                @if (array_key_exists('message_sent', $site_settings))
                    @if ($site_settings['message_sent'] == true)
                        <!-- Submit success message-->
                        <!---->
                        <!-- This is what your users will see when the form-->
                        <!-- has successfully submitted-->
                        <div id="submitSuccessMessage">
                            <div class="text-center text-white mb-3">
                                <div class="fw-bolder">Form submission successful!</div>
                            </div>
                        </div>
                    @else
                        <!-- Submit error message-->
                        <!---->
                        <!-- This is what your users will see when there is-->
                        <!-- an error submitting the form-->
                        <div id="submitErrorMessage">
                            <div class="text-center text-danger mb-3">Error sending message!</div>
                            <div class="text-center mb-3">
                                Please feel free to send us an e-mail via <a href="mailto:{{ config("MAIL_FROM_ADDRESS") }}" class="text-danger" style="text-decoration: none;">{{ config("MAIL_FROM_ADDRESS") }}</a>
                            </div>
                        </div>
                    @endif
                @endif
                <!-- Submit Button-->
                <div class="text-center"><button class="btn btn-primary btn-xl text-uppercase" id="submitButton"
                        type="submit">Send Message</button></div>
            </form>
        </div>
    </section>
    <x-slot name="slotextra">
        <!-- Services Modals-->
        @foreach ($services as $service)
            <!-- Service item {{ $service->id }} modal popup-->
            <div class="service-modal modal fade" id="serviceModal_{{ $service->id }}" tabindex="-1"
                role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="close-modal" data-bs-dismiss="modal"><img src="assets/img/close-icon.svg"
                                alt="Close modal" /></div>
                        <div class="modal-body">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-lg-8">
                                        <!-- Service details-->
                                        <img class="img-fluid d-block mx-auto" src="{{ $service->image }}"
                                            alt="..." />
                                        <h2 class="text-uppercase">{{ $service->title }}</h2>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="offset-lg-3 col-lg-7" style="text-align: left;">
                                        {!! $service->content !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </x-slot>
</x-public-layout>
