<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>{{ $title ?? 'Nash Vandayar & Associates' }}</title>
    <!-- Favicon-->
    <link rel="icon" type="image/x-icon" href="/assets/img/favicon/favicon.ico" />
    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('/css/styles.css') }}">
    <link rel="stylesheet" href="{{ asset('/vendor/bootstrap/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/vendor/bootstrap-icons/bootstrap-icons.min.css') }}">
</head>

<body id="page-top">
    <!-- Navigation-->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top" id="mainNav">
        <div class="container">
            <a class="navbar-brand" href="#page-top"><img src="{!! (array_key_exists('site-logo-image', $site_settings) && $site_settings['site-logo-image'])? $site_settings['site-logo-image']['value']: '/assets/img/logo.png' !!}" alt="..." /></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive"
                aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                Menu
                <i class="fas fa-bars ms-1"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarResponsive">
                <ul class="navbar-nav text-uppercase ms-auto py-4 py-lg-0">
                    <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
                    <li class="nav-item"><a class="nav-link" href="#services">Services</a></li>
                    <li class="nav-item"><a class="nav-link" href="#team">Team</a></li>
                    <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Masthead-->
    <header class="masthead" style="{!! (array_key_exists('site-banner-image', $site_settings) && $site_settings['site-banner-image'])? 'background-image: url(' . $site_settings['site-banner-image']['value'] . ') !important;': '\'\'' !!}">
        <div class="container">
            <div class="masthead-heading text-uppercase">{!! (array_key_exists('site-banner-heading', $site_settings) && $site_settings['site-banner-heading'])? $site_settings['site-banner-heading']['value']: '' !!}</div>
            <div class="masthead-subheading">{!! (array_key_exists('site-banner-sub-heading', $site_settings) && $site_settings['site-banner-sub-heading'])? $site_settings['site-banner-sub-heading']['value']: '' !!}</div>
            @if((array_key_exists('site-banner-heading', $site_settings) && $site_settings['site-banner-heading'])
                    || (array_key_exists('site-banner-sub-heading', $site_settings) && $site_settings['site-banner-sub-heading']))
                <a class="btn btn-primary btn-xl text-uppercase" href="#services">Tell Me More</a>
            @endif
        </div>
    </header>
    <main>
        {{ $slot }}
        {{ $slotextra ?? '' }}
    </main>
    <!-- Footer-->
    <footer class="footer py-4">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 text-lg-start">Copyright &copy; <strong class="px-1 sitename">{{ config('app.name', 'Nash Vandayar & Associates') }}</strong> All Rights Reserved</div>
                <div class="col-lg-6 text-end my-3 my-lg-0">
                    @if (array_key_exists('site-social-media-twitter-link', $site_settings) && $site_settings['site-social-media-twitter-link']['value'])
                        <a class="btn btn-dark btn-social mx-2" href="{{ $site_settings['site-social-media-twitter-link']['value'] }}" aria-label="Twitter"><i
                                class="bi bi-twitter" target="_blank"></i></a>
                    @endif
                    @if (array_key_exists('site-social-media-facebook-link', $site_settings) && $site_settings['site-social-media-facebook-link']['value'])
                        <a class="btn btn-dark btn-social mx-2" href="{{ $site_settings['site-social-media-facebook-link']['value'] }}" aria-label="Facebook"><i
                                class="bi bi-facebook" target="_blank"></i></a>
                    @endif
                    @if (array_key_exists('site-social-media-linkedin-link', $site_settings) && $site_settings['site-social-media-linkedin-link']['value'])
                        <a class="btn btn-dark btn-social mx-2" href="{{ $site_settings['site-social-media-linkedin-link']['value'] }}" aria-label="LinkedIn"><i
                                class="bi bi-linkedin" target="_blank"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </footer>
    <script src="/vendor/bootstrap/bootstrap.min.js"></script>
    <script src="/js/scripts.js"></script>
</body>

</html>
