<x-admin-layout>

    <div class="row">
        <div class="col-12 ps-5">
            <h5>{{ Str::ucfirst($sub_category != ''? $sub_category: $category) }} Settings</h5>
        </div>
    </div>
    <div class="row">
        <div class="col-12 pt-0 p-5">
            <form action="{{ route('admin.home.update') }}" method="post" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <input type="hidden" name="category" id="category" value="{{ $category }}" />
                <input type="hidden" name="sub_category" id="sub_category" value="{{ $sub_category }}" />
                <div class="card">
                    <div class="card-body">
                        @foreach ($site_settings as $site_setting)
                            @if ($site_setting['type'] == 'html')
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label for="{{ $site_setting['element_id'] }}" class="form-label"><strong>{{ Str::ucfirst($site_setting['element_label']) }}:</strong></label>
                                        <textarea class="class-wysiwyg form-control @error('{{ $site_setting["element_id"] }}') is-invalid @enderror" style="height:150px"
                                            name="{{ $site_setting['element_id'] }}" id="{{ $site_setting['element_id'] }}" placeholder="{{ $site_setting['element_label'] }}">{!! $site_setting['value'] !!}</textarea>
                                        @error('{{ $site_setting["element_id"] }}')
                                            <div class="form-text text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            @elseif ($site_setting['type'] == 'image')
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label for="{{ $site_setting['element_id'] }}" class="form-label"><strong>{{ Str::ucfirst($site_setting['element_label']) }}:</strong></label>
                                        <input type="file" name="{{ $site_setting['element_id'] }}"
                                            class="form-control @error('{{ $site_setting["element_id"] }}') is-invalid @enderror"
                                            id="{{ $site_setting['element_id'] }}" placeholder="{{ $site_setting['element_label'] }}">
                                        @error('{{ $site_setting["element_id"] }}')
                                            <div class="form-text text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                @if ($site_setting['value'])
                                    <div class="row">
                                        <div class="col-3 mb-3">
                                            <img src="{!! $site_setting['value'] !!}" class="img-fluid" alt="">
                                        </div>
                                    </div>
                                @endif
                            @elseif ($site_setting['type'] == 'checkbox')
                                <label for="{{ $site_setting['element_id'] }}" class="form-label">
                                    <input class="form-check-input" type="checkbox" id="{{ $site_setting['element_id'] }}"
                                        name="{{ $site_setting['element_id'] }}"
                                        value="1"
                                        {{ $site_setting['value'] == '1' ? 'checked' : '' }} />
                                    <strong>{{ Str::ucfirst($site_setting['element_label']) }}</strong>
                                </label>
                            @else
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label for="{{ $site_setting['element_id'] }}" class="form-label"><strong>{{ Str::ucfirst($site_setting['element_label']) }}:</strong></label>
                                        <input type="text" name="{{ $site_setting['element_id'] }}"
                                            class="form-control @error('{{ $site_setting["element_id"] }}') is-invalid @enderror" id="{{ $site_setting['element_id'] }}"
                                            placeholder="{{ $site_setting['element_label'] }}" value="{{ $site_setting['value'] }}">
                                        @error('{{ $site_setting["element_id"] }}')
                                            <div class="form-text text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            @endif
                        @endforeach
                        <div class="row">
                            <div class="col-6 mb-3">
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <x-slot name="script">
        <script src="{{ asset('vendor/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: 'textarea.class-wysiwyg',
                plugins: 'code table lists',
                toolbar: 'undo redo | blocks | bold italic | alignleft aligncenter alignright | indent outdent | bullist numlist | code | table'
            });
        </script>
    </x-slot>
</x-admin-layout>
