<x-admin-layout>
    <div class="row">
        <div class="col-12 ps-5">
            <h5><strong>Update</strong> {!! Str::ucfirst($title) !!}</h5>
        </div>
    </div>

    <div class="row">
        <div class="col-12 pt-0 p-5">

            <form action="{{ route("admin.page.page_item.update", [$page_item->page, $page_item]) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">

                                @if ($page_item->page->page_layout->type == 'list')
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="is_active" class="form-label">
                                                <input class="form-check-input" type="checkbox" id="active"
                                                    name="active" value="1" {{ $page_item['publish_date'] ? 'checked' : '' }}>
                                                <strong>Active</strong>
                                            </label>
                                            @error('is_active')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page_item->page->page_layout->hasField('title'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="title" class="form-label"><strong>Title:</strong></label>
                                            <textarea class="class-wysiwyg-sm form-control @error('title') is-invalid @enderror" style="height:150px" name="title"
                                                id="title" placeholder="Intro">{!! $page_item['title'] !!}</textarea>
                                            @error('title')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page_item->page->page_layout->hasField('thumb_image'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="thumb_image" class="form-label"><strong>Thumb Image:</strong></label>
                                            <input type="file" name="thumb_image"
                                                class="form-control @error('thumb_image') is-invalid @enderror" id="thumb_image"
                                                placeholder="Thumb image">
                                            @error('thumb_image')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    @if ($page_item['thumb_image'])
                                        <div class="row">
                                            <div class="col-6 mb-3">
                                                <img src="{!! $page_item['thumb_image'] !!}" class="img-fluid" alt="">
                                            </div>
                                        </div>
                                    @endif
                                @endif

                                @if ($page_item->page->page_layout->hasField('image'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="image" class="form-label"><strong>Image:</strong></label>
                                            <input type="file" name="image"
                                                class="form-control @error('image') is-invalid @enderror" id="image"
                                                placeholder="Image">
                                            @error('image')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    @if ($page_item['image'])
                                        <div class="row">
                                            <div class="col-6 mb-3">
                                                <img src="{!! $page_item['image'] !!}" class="img-fluid" alt="">
                                            </div>
                                        </div>
                                    @endif
                                @endif

                                @if ($page_item->page->page_layout->hasField('intro'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="intro" class="form-label"><strong>Intro:</strong></label>
                                            <textarea class="class-wysiwyg form-control @error('intro') is-invalid @enderror" style="height:150px" name="intro"
                                                id="intro" placeholder="Intro">{!! $page_item['intro'] !!}</textarea>
                                            @error('intro')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page_item->page->page_layout->hasField('content'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="content" class="form-label"><strong>Content:</strong></label>
                                            <textarea class="class-wysiwyg form-control @error('content') is-invalid @enderror" style="height:150px" name="content"
                                                id="content" placeholder="Content">{!! $page_item['content'] !!}</textarea>
                                            @error('content')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <x-slot name="script">
        <script src="{{ asset('vendor/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: 'textarea.class-wysiwyg-sm',
                plugins: 'code table lists',
                toolbar: 'undo redo | blocks | bold italic | alignleft aligncenter alignright | indent outdent | bullist numlist | code | table',
                height: '200px',
            });
            tinymce.init({
                selector: 'textarea.class-wysiwyg',
                plugins: 'code table lists',
                toolbar: 'undo redo | blocks | bold italic | alignleft aligncenter alignright | indent outdent | bullist numlist | code | table',
            });
        </script>
    </x-slot>
</x-admin-layout>
