<x-admin-layout>
    <div class="row">
        <div class="col-12 ps-5">
            <h5><strong>New</strong> {{ Str::ucfirst($page->title) }}*</h5>
        </div>
    </div>

    <div class="row">
        <div class="col-12 pt-0 p-5">

            <form action="{{ route("admin.page.page_item.store", $page) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">

                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label for="active" class="form-label">
                                            <input class="form-check-input" type="checkbox" id="active"
                                                name="active" value="1" />
                                            <strong>Active</strong>
                                        </label>
                                        @error('active')
                                            <div class="form-text text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                @if ($page->page_layout->hasField('title'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="title" class="form-label"><strong>Title:</strong></label>
                                            <input type="text" name="title"
                                                class="form-control @error('title') is-invalid @enderror" id="title"
                                                placeholder="Title">
                                            @error('title')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page->page_layout->hasField('thumb_image'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="thumb_image" class="form-label"><strong>Thumb Image:</strong></label>
                                            <input type="file" name="thumb_image"
                                                class="form-control @error('thumb_image') is-invalid @enderror" id="thumb_image"
                                                placeholder="Thumb image">
                                            @error('thumb_image')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page->page_layout->hasField('image'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="image" class="form-label"><strong>Image:</strong></label>
                                            <input type="file" name="image"
                                                class="form-control @error('image') is-invalid @enderror" id="image"
                                                placeholder="Image">
                                            @error('image')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page->page_layout->hasField('intro'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="intro" class="form-label"><strong>Intro:</strong></label>
                                            <textarea class="class-wysiwyg form-control @error('intro') is-invalid @enderror" style="height:150px" name="intro"
                                                id="intro" placeholder="Intro"></textarea>
                                            @error('intro')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif

                                @if ($page->page_layout->hasField('content'))
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label for="content" class="form-label"><strong>Content:</strong></label>
                                            <textarea class="class-wysiwyg form-control @error('content') is-invalid @enderror" style="height:150px" name="content"
                                                id="content" placeholder="Content"></textarea>
                                            @error('content')
                                                <div class="form-text text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <x-slot name="script">
        <script src="{{ asset('vendor/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: 'textarea.class-wysiwyg',
                plugins: 'code table lists',
                toolbar: 'undo redo | blocks | bold italic | alignleft aligncenter alignright | indent outdent | bullist numlist | code | table'
            });
        </script>
    </x-slot>
</x-admin-layout>
