<x-admin-layout>
    <div class="row">
        <div class="col-12 ps-5">
            <h5>{{ Str::ucfirst($page->title) }}</h5>
        </div>
    </div>
    <div class="row">
        <div class="col-12 pt-0 p-5">
            <div class="card">
                <div class="card-header text-right">
                    <a class="ms-1 btn btn-secondary btn-sm" href="{{ route("admin.page.settings", $page->name) }}"
                        style="float:right">advanced</a>
                    <a class="btn btn-primary btn-sm" href="{{ route("admin.page.page_item.create", $page->name) }}"
                        style="float:right">add</a>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Title</th>
                                <th scope="col">Author</th>
                                <th scope="col">Published</th>
                                <th scope="col" class="text-center">&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($page->page_items as $page_item)
                                <tr>
                                    <th scope="row"></th>
                                    <td>{{ $page_item['title'] }}</td>
                                    <td>{{ $page_item['author']['name'] }}</td>
                                    <td>{{ $page_item['publish_date'] }}</td>
                                    <td class="text-center">
                                        <a class="btn btn-primary btn-sm"
                                            href="{{ route("admin.page.page_item.edit", [$page->name, $page_item]) }}">edit</a>
                                        <form method="POST"
                                            action="{{ route("admin.page.page_item.destroy", [$page, $page_item]) }}"
                                            style="width: fit-content; display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                onclick="return confirm('Are you sure?')">delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
