<?php

namespace App\View\Components;

use Illuminate\View\Component;
use App\Http\Handlers\SiteSettingsHandler;

class PublicLayout extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $site_settings = (new SiteSettingsHandler('site'))->getSiteSettings();
        return view('components.public-layout')->with(['site_settings' => $site_settings]);
    }
}
