<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PageLayout extends Model
{
    use HasFactory;
    protected $fillable =
    [
        'name',
        'fields',
        'type',
    ];

    public function pages(): HasMany
    {
        return $this->hasMany(Page::class);
    }

    public function hasField($search): bool
    {
        $fields = json_decode($this->fields);
        foreach($fields as $field) {
            if($field == $search) return true;
        }
        return false;
    }
}
