<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PageItem extends Model
{
    use HasFactory;
    protected $fillable =
    [
        'author_id',
        'page_id',
        'title',
        'thumb_image',
        'image',
        'intro',
        'content',
        'publish_date',
        'views',
    ];

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'author_id');
    }

    public function page(): BelongsTo
    {
        return $this->belongsTo(Page::class);
    }
}
