<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Page extends Model
{
    use HasFactory;
    protected $fillable =
    [
        'page_layout_id',
        'title',
        'name',
        'banner_image',
        'banner_text',
        'page_info',
        'translate',
        'order',
    ];

    public function page_layout(): BelongsTo
    {
        return $this->belongsTo(PageLayout::class);
    }

    public function page_items(): HasMany
    {
        return $this->hasMany(PageItem::class);
    }
}
