<?php

namespace App\Http\Middleware;

use App\Models\SiteSetting;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UnderConstruction
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $under_construction = SiteSetting::Where('category', '=', 'site')
            ->firstWhere('key', '=', 'under-construction')
            ->value;

        if ($under_construction == 1 && !Auth::check()) {
            return redirect(route("underconstruction"));
        }
        return $next($request);
    }
}
