<?php

namespace App\Http\Handlers;

use App\Models\SiteSetting;

class SiteSettingsHandler
{
    private $Category;
    private $SubCategory;
    private $Key;

    public function __construct(string $category, string $sub_category = '', string $key = '')
    {
        $this->Category = $category;
        $this->SubCategory = $sub_category;
        $this->Key = $key;
    }

    public function getSiteSettings(): array
    {
        $query = SiteSetting::where('category', '=', $this->Category);
        if (!empty($this->SubCategory)) $query->where('sub_category', '=', $this->SubCategory);
        if (!empty($this->Key)) $query->where('key', '=', $this->Key);

        $site_settings = $query->get();

        $site_settings_data = [];
        foreach ($site_settings as $site_setting) {
            $site_settings_data[$site_setting['category'] . "-" . $site_setting['sub_category'] . "-" . $site_setting['key']] = [
                    'category'=> $site_setting['category'],
                    'sub_category'=> $site_setting['sub_category'],
                    'key'=> $site_setting['key'],
                    'value'=> $site_setting['value'],
                    'type'=> $site_setting['type'],
                    'element_label' => str_replace("-", " ", $site_setting['key']),
                    'element_id'=> SiteSettingsHandler::getElementId($site_setting),
                ];
        }
        return $site_settings_data;
    }

    public static function getElementId($site_setting): string {
        return str_replace("-", "", $site_setting['category']) . "_" .
                                    str_replace("-", "", $site_setting['sub_category']) . "_" .
                                    str_replace("-", "", $site_setting['key']);
    }
}
