<?php

namespace App\Http\Controllers;

use App\Http\Handlers\SiteSettingsHandler;
use App\Models\Page;
use App\Models\SiteSetting;
use Illuminate\Http\Request;

class SiteSettingsController extends Controller
{
    public function update(Request $request)
    {
        $data = $request->all();

        $query = SiteSetting::where('category', '=', $data['category']);
        if(!empty($data['sub_category'])) $query->where('sub_category', '=', $data['sub_category']);
        $site_settings = $query->get();

        foreach($site_settings as $site_setting) {
            $element_id = SiteSettingsHandler::getElementId($site_setting);

            if(array_key_exists($element_id, $data) && $data[$element_id]) {
                if($site_setting->type == 'image') {
                    $image_name = time().".".$data[$element_id]->extension();
                    $location = "/assets/img/" .  ($site_setting['category']=='page' && !empty($site_setting['sub_category'])? "page" . $site_setting['sub_category']: $site_setting['category']) . "/";
                    $request->files->get($element_id)->move(public_path($location), $image_name);
                    $site_setting->value = $location . $image_name;
                } else {
                    $site_setting->value = $data[$element_id];
                }
            } elseif($site_setting->type == 'checkbox') {
                $site_setting->value = '0';
            } elseif($site_setting->type != 'image') {
                $site_setting->value = '';
            }

            $site_setting->save();
        }

        if($data['category'] == 'page') {
            return ($data['sub_category'] == 'contact')?
                redirect()->route('admin.messages'):
                redirect()->route('admin.page', Page::firstWhere('name', '=', $data['sub_category'])->name);
        }
        return redirect()->route('admin.home');
    }
}
