<?php

namespace App\Http\Controllers;

use App\Models\Page;
use App\Models\PageItem;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PageItemController extends Controller
{

    public function create($page)
    {
        $page = Page::with(['page_layout', 'page_items', 'page_items.author'])
            ->firstWhere('name', '=', $page);

        if(!$page) return view('admin.404');

        return view("admin.page.page_item.create")
            ->with([
                "page" => $page,
            ]);
    }

    public function store(Request $request, $page)
    {
        $data = $request->all();
        $page = Page::firstWhere('id', '=', $page);
        $page_item_data = [
            "page_id" => $page->id,
            "author_id" => Auth::user()->id,
            "title" => array_key_exists('title', $data)? trim(trim($data['title'], "<p>"), "</p>"): null,
            "intro" => array_key_exists('intro', $data)? $data['intro']: null,
            "content" => array_key_exists('content', $data)? $data['content']: null,
        ];

        $page_item_data["publish_date"] = array_key_exists('active', $data) && $data["active"] == "1"? Carbon::now(): null;

        if(array_key_exists('thumb_image', $data)) {
            $thumb_name = time().".".$data['thumb_image']->extension();
            $request->thumb->move(public_path("assets/img/thumb/$page->name"), $thumb_name);
            $page_item_data["thumb_image"] = "/assets/img/$page->name/thumb/$thumb_name";
        }

        if(array_key_exists('thumb_image', $data)) {
            $image_name = time().".".$data["image"]->extension();
            $request->image->move(public_path("assets/img/$page->name"), $image_name);
            $page_item_data["image"] = "/assets/img/$page->name/$image_name";
        }

        PageItem::create($page_item_data);

        return redirect()->route("admin.page", $page->name);
    }

    public function edit($page, $page_item)
    {
        $page_item = PageItem::with(['page', 'page.page_layout', 'author'])
            ->firstWhere("id", "=", $page_item);

        return view("admin.page.page_item.edit")
            ->with([
                "title" => $page_item->page->page_layout->type == "detail"? $page_item->page->title: $page_item->title,
                "page_item" => $page_item,
            ]);
    }

    public function update(Request $request, Page $page, $page_item)
    {
        $data = $request->all();

        $title = null;
        if(array_key_exists('title', $data)
            && strlen($data['title']) > 4
            && substr($data['title'], 0, 3) == "<p>"
            && substr($data['title'], -4, 4) == "</p>") {
            $title = substr($data['title'], 3, strlen($data['title']) - 7);
        }
        $page_item = PageItem::with(['page', 'page.page_layout', 'author'])
            ->firstWhere("id", "=", $page_item);
        $page_item_data = [
            "title" => $title,
            "intro" => array_key_exists('intro', $data)? $data['intro']: null,
            "content" => array_key_exists('content', $data)? $data['content']: null,
        ];

        if(array_key_exists('thumb_image', $data)) {
            $thumb_name = time().".".$data['thumb_image']->extension();
            $location =  "/assets/img/page/$page->name/thumb/";
            $request->thumb->move(public_path($location), $thumb_name);
            $page_item_data["thumb_image"] = "$location$thumb_name";
        }

        if(array_key_exists('thumb_image', $data)) {
            $image_name = time().".".$data["image"]->extension();
            $location =  "assets/img/page/$page->name/";
            $request->image->move(public_path($location), $image_name);
            $page_item_data["image"] = "$location$image_name";
        }

        $page_item_data["publish_date"] = (array_key_exists('active', $data) && $data["active"] == "1") || $page_item->page->page_layout->type == 'detail'?
                                            Carbon::now():
                                            null;

        $page_item->update($page_item_data);
        $page_item->save();

        return $page_item->page->page_layout->type == "detail"?
            redirect()->route("admin.page.page_item.edit", [$page->name, $page->page_items->first()]):
            redirect()->route("admin.page", $page_item->page->name);
    }

    public function destroy(Page $page, PageItem $page_item)
    {
        $page_item->delete();

        return redirect()->route("admin.page", $page->name);
    }
}
