<?php

namespace App\Http\Controllers;

use App\Http\Handlers\SiteSettingsHandler;
use App\Models\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(string $page)
    {
        $page = Page::with(['page_layout', 'page_items', 'page_items.author'])
            ->firstWhere('name', '=', $page);

        if(!$page) return view('admin.404');

        return $page->page_layout->type == 'detail'?
            redirect()->route("admin.page.page_item.edit", [$page->name, $page->page_items->first()]):
            view('admin.page.index')->with(['page' => $page]);
    }

    public function settings(string $page){
        $page = Page::with(['page_layout', 'page_items', 'page_items.author'])
            ->firstWhere('name', '=', $page);

        if(!$page) return view('admin.404');

        $site_settings = (new SiteSettingsHandler('page', $page->name))->getSiteSettings();

        return view('admin.site_settings.index')->with(['category' => 'page',
                                                        'sub_category' => $page->name,
                                                        'site_settings' => $site_settings]);

    }
}
