<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;
use App\Http\Handlers\SiteSettingsHandler;
use App\Models\PageItem;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $about = Page::with(['page_items'])
            ->firstWhere('title', '=', 'about')
            ->page_items
            ->first();

        $services = PageItem::with(['page'])
            ->where('page_id', '=', Page::firstWhere('name', '=', 'services')->id)
            ->where('publish_date',  '!=',  null)
            ->orderBy('id')
            ->get();
        $team = PageItem::with(['page'])
            ->where('page_id', '=', Page::firstWhere('name', '=', 'team')->id)
            ->where('publish_date',  '!=',  null)
            ->orderBy('id')
            ->get();

        $site_settings = (new SiteSettingsHandler('page'))->getSiteSettings();

        if($request->session()->exists("message_sent")) $site_settings["message_sent"] = $request->session()->get("message_sent");

        return view('public.index')->with(['site_settings' => $site_settings,
                                                        'about' => $about,
                                                        'services' => $services,
                                                        'team' => $team]);
    }

    public function settings(){
        $site_settings = (new SiteSettingsHandler('site'))->getSiteSettings();

        return view('admin.site_settings.index')->with(['category' => 'site',
                                                        'sub_category' => '',
                                                        'site_settings' => $site_settings]);

    }
}
